import _ from "underscore";
let previousVariationData = {};

export const dataProcessing = (productDetails, variationData) => {
    const {
        attributes: allAttributes,
        variations: allVariations,
        attribute_values,
    } = productDetails?.data;

    let attributes = {};
    for (let item in allAttributes) {
        if (allAttributes[item].variation == 1) {
            attributes[item] = allAttributes[item];
        }
    }
    let attributeKeys = Object.keys(attributes);

    let variations = allVariations.map((item) => {
        const newAtt = {};
        for (let att in item.attributes) {
            let postfix = att.split("_").pop();
            if (attributeKeys.indexOf(postfix) !== -1) {
                newAtt[att] = item.attributes[att];
            }
        }
        return {
            ...item,
            attributes: newAtt,
        };
    });

    let userSelectVariation = convertValueToId(variationData, attribute_values);
    let attributeValue = {};
    let attributeId = {};
    for (let item in attributes) {
        attributeValue[item] = attributes[item]?.value;
        attributeId[item] = attributes[item]?.attribute_id;
    }

    let obj = {};
    let emptyKeys = [];
    for (let i = 0; i < attributeKeys.length; i++) {
        obj[attributeKeys[i]] = {
            value: [],
        };
    }
    
    previousVariationData = userSelectVariation;
    let isValue = {};
    let unselectValueOfVariation = [];
    const isEmptyAll = Object.keys(userSelectVariation).every(
        (x) => userSelectVariation[x] == ""
    );

    if (isEmptyAll) {
        for (let item of variations) {
            Object.keys(item.attributes).forEach((key) => {
                let postfixKey = key.split("_").pop();
                collectValueInOptions(postfixKey, item, key);
            });
        }
    } else {
        for (let userVariation in userSelectVariation) {
            let addPrefixUserVariation = `attribute_${userVariation}`;
            if (userSelectVariation[userVariation]) {
                isValue[addPrefixUserVariation] =
                    userSelectVariation[userVariation];
            }
        }
        for (let variation of variations) {
            let isMatch = Object.keys(isValue).every(
                (k) =>
                    variation.attributes[k] == isValue[k] ||
                    "" == variation.attributes[k]
            );

            if (isMatch) {
                unselectValueOfVariation.push(variation);
            }
        }
        let isEmptyValue = objectEmptyProperty(userSelectVariation);
        variationCombination(unselectValueOfVariation, isEmptyValue);

        for (let v in isValue) {
            let withoutSelectLastValue = {};
            let withoutSelectLastValueOfVariation = [];
            let isSelectedValue = {};

            for (let variation of variations) {
                for (let vv in isValue) {
                    if (v != vv) {
                        withoutSelectLastValue[vv] = isValue[vv];
                    }
                }

                let isMatch = Object.keys(withoutSelectLastValue).every(
                    (k) =>
                        variation.attributes[k] == withoutSelectLastValue[k] ||
                        "" == variation.attributes[k]
                );
                if (isMatch) {
                    withoutSelectLastValueOfVariation.push(variation);
                }
            }

            let changeableAttribute = differenceTwoObject(isValue);
            for (let v in changeableAttribute) {
                let value = v.split("_").pop();
                isSelectedValue[value] = changeableAttribute[v];
            }
            variationCombination(
                withoutSelectLastValueOfVariation,
                isSelectedValue
            );
        }
    }

    function variationCombination(variations, changeableObj) {
        for (let item of variations) {
            Object.keys(item.attributes).forEach((key) => {
                let postfixKey = key.split("_").pop();
                for (let value in changeableObj) {
                    if (value == postfixKey) {
                        collectValueInOptions(postfixKey, item, key);
                    }
                }
            });
        }
    }

    function collectValueInOptions(postfixKey, item, key) {
        if (
            item.attributes[key] == "" &&
            emptyKeys.indexOf(postfixKey) == -1
        ) {
            emptyKeys.push(postfixKey);
            if (attributeId[postfixKey]) {
                convertIdToValue(postfixKey, item, key);
            } else {
                obj[postfixKey].value = attributeValue[postfixKey];
            }
        } else if (
            item.attributes[key] &&
            obj[postfixKey].value.indexOf(item.attributes[key]) == -1
        ) {
            if (attributeId[postfixKey]) {
                convertIdToValue(postfixKey, item, key);
            } else {
                obj[postfixKey].value.push(item.attributes[key]);
            }
        }
    }

    function differenceTwoObject(previous) {
        let diffObj = _.omit(previous, (v, k) => userSelectVariation[k] == v);
        return diffObj;
    }

    function convertIdToValue(postfixKey, item, key) {
        for (let a in attribute_values[postfixKey]) {
            if (
                emptyKeys.indexOf(postfixKey) != -1 &&
                obj[postfixKey].value.indexOf(
                    attribute_values[postfixKey][a]?.value
                ) == -1
            ) {
                obj[postfixKey].value.push(
                    attribute_values[postfixKey][a]?.value
                );
            } else if (
                attribute_values[postfixKey][a]?.attribute_id ==
                    attributeId[postfixKey] &&
                attribute_values[postfixKey][a]?.id == item.attributes[key] &&
                obj[postfixKey].value.indexOf(
                    attribute_values[postfixKey][a]?.value
                ) == -1
            ) {
                obj[postfixKey].value.push(
                    attribute_values[postfixKey][a]?.value
                );
            }
        }
    }

    let status = 1;
    for (let item in obj) {
        obj[item].value.sort();
        for (let i in obj[item]) {
            if (obj[item][i]?.length == 0) {
                status = 0;
            }
        }
    }
    return { status, obj };
};

const convertValueToId = (variationData, attribute_values) => {
    let userSelectVariation = { ...variationData };
    for (let key in userSelectVariation) {
        if (attribute_values[key]) {
            for (let item in attribute_values[key]) {
                if (
                    key == "color" &&
                    userSelectVariation[key] ==
                        attribute_values[key][item].value.toLowerCase()
                ) {
                    userSelectVariation[key] = attribute_values[key][item].id;
                } else if (
                    userSelectVariation[key] ==
                    attribute_values[key][item].value
                ) {
                    userSelectVariation[key] = attribute_values[key][item].id;
                }
            }
        }
    }
    return userSelectVariation;
};

const objectEmptyProperty = (userSelectVariation) => {
    let isEmptyValue = {};
    for (let item in userSelectVariation) {
        if (userSelectVariation[item] == "") {
            isEmptyValue[item] = "";
        }
    }
    return isEmptyValue;
};
